VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "mscomm32.ocx"
Begin VB.UserControl DALIControl 
   Alignable       =   -1  'True
   CanGetFocus     =   0   'False
   ClientHeight    =   3270
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3270
   ClipControls    =   0   'False
   EditAtDesignTime=   -1  'True
   InvisibleAtRuntime=   -1  'True
   PaletteMode     =   4  'None
   ScaleHeight     =   3270
   ScaleWidth      =   3270
   ToolboxBitmap   =   "DALIControl.ctx":0000
   Begin MSCommLib.MSComm MSCom 
      Left            =   1560
      Top             =   960
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   0   'False
      RThreshold      =   1
      BaudRate        =   19200
      InputMode       =   1
   End
   Begin VB.Timer DALITimer 
      Left            =   360
      Top             =   1320
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   585
      Left            =   0
      Picture         =   "DALIControl.ctx":0532
      Top             =   0
      Width           =   585
   End
End
Attribute VB_Name = "DALIControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Enum TDALICommand
  DALI_DirectArcPowerControl = 0
  DALI_Off = 1
  DALI_Up = 2
  DALI_Down = 3
  DALI_StepUp = 4
  DALI_StepDown = 5
  DALI_RecallMaxLevel = 6
  DALI_RecallMinLevel = 7
  DALI_StepDownAndOff = 8
  DALI_OnAndStepUp = 9
  DALI_GoToScene = 10
  
  DALI_Reset = 11
  DALI_StoreActLevelToDTR = 12
  DALI_StoreDTRAsMaxLevel = 13
  DALI_StoreDTRAsMinLevel = 14
  DALI_StoreDTRAsSysFailureLevel = 15
  DALI_StoreDTRAsPowerOnLevel = 16
  DALI_StoreDTRAsFadeTime = 17
  DALI_StoreDTRAsFadeRate = 18
  DALI_StoreDTRAsSceneLevel = 19
  DALI_RemoveFromScene = 20
  DALI_AddToGroup = 21
  DALI_RemoveFromGroup = 22
  DALI_StoreDTRAsShortAddress = 23
  
  DALI_QueryStatus = 24
  DALI_QueryBallast = 25
  DALI_QueryLampFailure = 26
  DALI_QueryLampPowerOn = 27
  DALI_QueryLimitError = 28
  DALI_QueryResetState = 29
  DALI_QueryMissingShortAddress = 30
  DALI_QueryVersionNumber = 31
  DALI_QueryContentDTR = 32
  DALI_QueryDeviceType = 33
  DALI_QueryPhysicalMinLevel = 34
  DALI_QueryPowerFailure = 35
  DALI_QueryActualLevel = 36
  DALI_QueryMaxLevel = 37
  DALI_QueryMinLevel = 38
  DALI_QueryPowerOnLevel = 39
  DALI_QuerySysFailureLevel = 40
  DALI_QueryFadeTimeFadeRate = 41
  DALI_QuerySceneLevel = 42
  DALI_QueryGroups_0_7 = 43
  DALI_QueryGroups_8_15 = 44
  DALI_QueryRandomAddressH = 45
  DALI_QueryRandomAddressM = 46
  DALI_QueryRandomAddressL = 47
  DALI_QueryExtendedCommands = 48
  
  DALI_Terminate = 49
  DALI_SetDTR = 50
  DALI_Initialize = 51
  DALI_Randomize = 52
  DALI_Compare = 53
  DALI_Withdraw = 54
  DALI_SetSearchAddrH = 55
  DALI_SetSearchAddrM = 56
  DALI_SetSearchAddrL = 57
  DALI_ProgramShortAddress = 58
  DALI_VerifyShortAddress = 59
  DALI_QueryShortAddress = 60
  DALI_PhysicalSelection = 61
  DALI_EnableDeviceType = 62
  
  DALI_ST_StoreDTRAsFixPoint = 63
End Enum

Public Enum TDALIError
  DALI_A_ERR_InvalidFrames = 300
  DALI_A_ERR_CommandBufferOverrun = 301
  DALI_A_ERR_SCIReceiveTimeout = 302
  DALI_A_ERR_SCIReceiveOverflow = 303
  DALI_A_ERR_SCITimedOut = 304
  DALI_A_ERR_MultiUsed = 305
  DALI_A_ERR_NoAnswer = 306
  DALI_A_ERR_GeneralError = 307
End Enum

Public Enum TDALIAddress
  DALI_AD_SHORT = 0
  DALI_AD_GROUP = 64
  DALI_AD_BROADCAST = 127
End Enum

Public Enum TDALICommandFlags
  DALICD_NORMAL = 0
  DALICD_WAIT = 1
  DALICD_SENDTWICE = 2
  DALICD_SENDTWICEWAIT = 3
  DALICD_ANSWER = 4
End Enum

Public Enum TDALICommandAnswer
  DALICA_OK = 0
  DALICA_YESNO = 1
  DALICA_8BIT = 2
End Enum

Private Type TCommand
  Base As Long
  AMult As Long
  DMax As Long
  Flags As TDALICommandFlags
  Descr As String
  Answer As TDALICommandAnswer
End Type

Private CmdArray(63) As TCommand
'Private IniClass As SettingClass
Private isAnswerRcvd As Boolean
Private Answer(1) As Byte
Private hadReset As Boolean
Private isTimedOut As Boolean
Private bInFunction As Boolean
Private noError As Boolean

Private Const TimeOut% = 500

'Public inCompatMode As Boolean
'Public INI_File As String

Public Event DALIError(Errcode As TDALIError)


Public Property Get DALIVersion$()
  DALIVersion = "Draft January 10, 2000"
End Property

Public Property Let DALIVersion(newdv As String)
End Property

Public Property Get ControlVersion$()
  ControlVersion = App.Major & "." & App.Minor & "." & App.Revision
End Property

Public Property Let ControlVersion(newcv As String)
End Property

Public Property Let COMPort(newcp%)
  MSCom.CommPort = newcp
End Property

Public Property Get COMPort%()
  COMPort = MSCom.CommPort
End Property

Public Property Let PortOpen(newpo As Boolean)
  MSCom.PortOpen = newpo
End Property

Public Property Get PortOpen() As Boolean
  PortOpen = MSCom.PortOpen
End Property

Public Sub SupressErrors()
  noError = True
End Sub


Private Sub CreateCommandBytes(cb1 As Byte, cb2 As Byte, cb3 As Byte, cmd As TDALICommand, Address As Byte, Data As Byte)
  Dim Cmd16 As Long
  With CmdArray(cmd)
    Cmd16 = .Base + (Address * .AMult)
    If Not (.DMax = 0) Then
      Cmd16 = Cmd16 + Data
    End If
    cb1 = Cmd16 \ 256
    cb2 = Cmd16 Mod 256
    cb3 = .Flags
  End With
End Sub

Private Function ConvertError(DALIAns) As Integer
  Select Case DALIAns
    Case 1
      ConvertError = DALI_A_ERR_InvalidFrames
    Case 2
      ConvertError = (DALI_A_ERR_NoAnswer)
    Case 3
      ConvertError = (DALI_A_ERR_CommandBufferOverrun)
    Case 4
      ConvertError = (DALI_A_ERR_SCIReceiveTimeout)
    Case 5
      ConvertError = (DALI_A_ERR_SCIReceiveOverflow)
    Case Else
      ConvertError = ((DALIAns))
  End Select
End Function

Public Function SendCommand(cmd As TDALICommand, Optional Address As TDALIAddress = 0, Optional Data As Byte = 0) As Variant
  Dim sa(2) As Byte
  Dim a(1) As Byte
  Dim runTimer As Boolean
  

  If bInFunction Then
    RaiseEvent DALIError(DALI_A_ERR_MultiUsed)
    Exit Function
  End If
  bInFunction = True
  CreateCommandBytes sa(0), sa(1), sa(2), cmd, (Address), Data
  Select Case sa(2)
    Case 0
      SendCommandBytes sa(0), sa(1), 0
    Case 1
      SendCommandBytes sa(0), sa(1), 1
    Case 2
      SendCommandBytes sa(0), sa(1), 1
      GetAnswer a(0), a(1)
      SendCommandBytes sa(0), sa(1), 0
    Case 3
      SendCommandBytes sa(0), sa(1), 1
      GetAnswer a(0), a(1)
      SendCommandBytes sa(0), sa(1), 1
    Case 4
      SendCommandBytes sa(0), sa(1), 2
  End Select
  GetAnswer a(0), a(1)
  If isTimedOut Then
    If noError Then
      noError = False
      SendCommand = DALI_A_ERR_SCITimedOut
    Else
      RaiseEvent DALIError(DALI_A_ERR_SCITimedOut)
    End If
    bInFunction = False
    Exit Function
  Else
    Select Case CmdArray(cmd).Answer
      Case DALICA_OK
        If Not (a(0) = 0) Then
          If noError Then
            SendCommand = ConvertError(a(0))
            noError = False
          Else
            RaiseEvent DALIError(ConvertError(a(0)))
          End If
        End If
      Case DALICA_YESNO
        Select Case a(0)
          Case 0
            SendCommand = True
          Case 2
            SendCommand = False
          Case Else
            If noError Then
              SendCommand = ConvertError(a(0))
              noError = False
            Else
              RaiseEvent DALIError(ConvertError(a(0)))
            End If
        End Select
      Case DALICA_8BIT
        If a(0) = 0 Then
          SendCommand = a(1)
        Else
          If noError Then
            SendCommand = ConvertError(a(0))
            noError = False
          Else
            RaiseEvent DALIError(ConvertError(a(0)))
          End If
        End If
      Case Else
        If noError Then
          noError = False
        Else
          RaiseEvent DALIError(DALI_A_ERR_GeneralError)    'Should never happen
        End If
    End Select
  End If
    
  Select Case cmd
    Case DALI_Randomize
      DALITimer.Interval = 100
      runTimer = True
    Case DALI_Reset
      DALITimer.Interval = 300
      runTimer = True
    Case DALI_StoreDTRAsShortAddress
      DALITimer.Interval = 100
      runTimer = True
    Case DALI_StoreDTRAsFadeRate
      DALITimer.Interval = 100
      runTimer = True
    Case DALI_StoreDTRAsFadeTime
      DALITimer.Interval = 100
      runTimer = True
    Case Else
      runTimer = False
  End Select
  
  If runTimer Then
    isTimedOut = False
    DALITimer.Enabled = True
    Do
      DoEvents
    Loop Until isTimedOut
    DALITimer.Enabled = False
  End If
  bInFunction = False
End Function
  
Private Sub SendCommandBytes(cb1 As Byte, cb2 As Byte, cb3 As Byte)
  Dim sendarray(2) As Byte
  sendarray(0) = cb1
  sendarray(1) = cb2
  sendarray(2) = cb3
  'If Not inCompatMode Then
    sendarray(2) = sendarray(2) + 1
  isAnswerRcvd = False
  MSCom.Output = sendarray
End Sub

Public Function SendCommandManual(cb1 As Byte, cb2 As Byte, Flags As TDALICommandFlags, Optional ExpectedAnswer As TDALICommandAnswer = DALICA_OK) As Variant
  Dim sa(2) As Byte
  Dim a(1) As Byte
  Dim runTimer As Boolean
  

  If bInFunction Then
    RaiseEvent DALIError(DALI_A_ERR_MultiUsed)
    Exit Function
  End If
  bInFunction = True
  sa(0) = cb1
  sa(1) = cb2
  sa(2) = Flags
  Select Case sa(2)
    Case 0
      SendCommandBytes sa(0), sa(1), 0
    Case 1
      SendCommandBytes sa(0), sa(1), 1
    Case 2
      SendCommandBytes sa(0), sa(1), 1
      GetAnswer a(0), a(1)
      SendCommandBytes sa(0), sa(1), 0
    Case 3
      SendCommandBytes sa(0), sa(1), 1
      GetAnswer a(0), a(1)
      SendCommandBytes sa(0), sa(1), 1
    Case 4
      SendCommandBytes sa(0), sa(1), 2
  End Select
  GetAnswer a(0), a(1)
  If isTimedOut Then
    If noError Then
      noError = False
      SendCommandManual = DALI_A_ERR_SCITimedOut
    Else
      RaiseEvent DALIError(DALI_A_ERR_SCITimedOut)
    End If
    bInFunction = False
    Exit Function
  Else
    Select Case ExpectedAnswer
      Case DALICA_OK
        If Not (a(0) = 0) Then
          If noError Then
            SendCommandManual = ConvertError(a(0))
            noError = False
          Else
            RaiseEvent DALIError(ConvertError(a(0)))
          End If
        End If
      Case DALICA_YESNO
        Select Case a(0)
          Case 0
            SendCommandManual = True
          Case 2
            SendCommandManual = False
          Case Else
            If noError Then
              SendCommandManual = ConvertError(a(0))
              noError = False
            Else
              RaiseEvent DALIError(ConvertError(a(0)))
            End If
        End Select
      Case DALICA_8BIT
        If a(0) = 0 Then
          SendCommandManual = a(1)
        Else
          If noError Then
            SendCommandManual = ConvertError(a(0))
            noError = False
          Else
            RaiseEvent DALIError(ConvertError(a(0)))
          End If
        End If
      Case Else
        If noError Then
          noError = False
        Else
          RaiseEvent DALIError(DALI_A_ERR_GeneralError)    'Should never happen
        End If
    End Select
  End If
    
'  Select Case cmd
'    Case DALI_Randomize
'      DALITimer.Interval = 100
'      runTimer = True
'    Case DALI_Reset
'      DALITimer.Interval = 300
'      runTimer = True
'    Case DALI_StoreDTRAsShortAddress
'      DALITimer.Interval = 100
'      runTimer = True
'    Case Else
'      runTimer = False
'  End Select
  
  If runTimer Then
    isTimedOut = False
    DALITimer.Enabled = True
    Do
      DoEvents
    Loop Until isTimedOut
    DALITimer.Enabled = False
  End If
  bInFunction = False
End Function

Private Function isAnswerReceived() As Boolean
  isAnswerReceived = isAnswerRcvd
End Function

Private Sub GetAnswer(ByRef Ans0 As Byte, ByRef Ans1 As Byte)
  
  isTimedOut = False
  DALITimer.Interval = TimeOut
  DALITimer.Enabled = True
  
  Do
    DoEvents
  Loop Until isAnswerRcvd
  DALITimer.Enabled = False
  Ans0 = Answer(0)
  Ans1 = Answer(1)
End Sub

Public Function GetDescr$(i As TDALICommand)
  GetDescr = CmdArray(i).Descr
End Function

Public Function isDataRqrd(i As TDALICommand)
  isDataRqrd = True
  If CmdArray(i).DMax = 0 Then isDataRqrd = False
End Function

Public Function GetDMax(i As TDALICommand)
  GetDMax = CmdArray(i).DMax
End Function

Public Function isAddrRqrd(i As TDALICommand)
  isAddrRqrd = True
  If CmdArray(i).AMult = 0 Then isAddrRqrd = False
End Function

Private Function isAnswerRqrd(i As TDALICommand) As Boolean
  If CmdArray(i).Flags = 4 Then
    isAnswerRqrd = True
  Else
    isAnswerRqrd = False
  End If
End Function

Public Function WhatTypeOfAnswer(i As TDALICommand) As TDALICommandAnswer
  WhatTypeOfAnswer = CmdArray(i).Answer
End Function

Public Function isSendTwice(i As TDALICommand) As Boolean
  Select Case CmdArray(i).Flags
    Case 2
      isSendTwice = True
    Case 3
      isSendTwice = True
    Case Else
      isSendTwice = False
  End Select
End Function

Public Function isWait(i As TDALICommand) As Boolean
  Select Case CmdArray(i).Flags
    Case 1
      isWait = True
    Case 3
      isWait = True
    Case Else
      isWait = False
  End Select
End Function

'Private Sub xxxLoadDALICommands()
'  'Load Commands from File
'  Dim res$
'  Dim i%
'  Set IniClass = New SettingClass
'
'  IniClass.Init INI_File
'
'  For i = 0 To 100
'    res = IniClass.GetStrSpc("Cmd" & Format(i), "Descr", "")
'    CmdArray(i).Descr = res
'    CmdArray(i).Base = IniClass.GetLong("Cmd" & Format(i), "Base", 0)
'    CmdArray(i).AMult = IniClass.GetLong("Cmd" & Format(i), "AMult", 0)
'    CmdArray(i).DMax = IniClass.GetLong("Cmd" & Format(i), "DMax", 0)
'    CmdArray(i).Flags = IniClass.GetInt("Cmd" & Format(i), "Flags", 0)
'  Next i
'End Sub

Private Sub LoadDALICommands()
  With CmdArray(0)
    .Base = 0
    .AMult = 512
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Direct ARC Power Control"
    .Answer = DALICA_OK
  End With

  With CmdArray(1)
    .Base = 256
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Off"
    .Answer = DALICA_OK
  End With

  With CmdArray(2)
    .Base = 257
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Up"
    .Answer = DALICA_OK
  End With

  With CmdArray(3)
    .Base = 258
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Down"
    .Answer = DALICA_OK
  End With

  With CmdArray(4)
    .Base = 259
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Step Up"
    .Answer = DALICA_OK
  End With

  With CmdArray(5)
    .Base = 260
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Step Down"
    .Answer = DALICA_OK
  End With

  With CmdArray(6)
    .Base = 261
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Recall Max Level"
    .Answer = DALICA_OK
  End With

  With CmdArray(7)
    .Base = 262
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Recall Min Level"
    .Answer = DALICA_OK
  End With

  With CmdArray(8)
    .Base = 263
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Step Down And OFF"
    .Answer = DALICA_OK
  End With

  With CmdArray(9)
    .Base = 264
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "ON And Step Up"
    .Answer = DALICA_OK
  End With

  With CmdArray(10)
    .Base = 272
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_NORMAL
    .Descr = "Go To Scene"
    .Answer = DALICA_OK
  End With



  With CmdArray(11)
    .Base = 288
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Reset"
    .Answer = DALICA_OK
  End With

  With CmdArray(12)
    .Base = 289
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store Act Level to DTR"
    .Answer = DALICA_OK
  End With

  With CmdArray(13)
    .Base = 298
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Max"
    .Answer = DALICA_OK
  End With

  With CmdArray(14)
    .Base = 299
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Min"
    .Answer = DALICA_OK
  End With

  With CmdArray(15)
    .Base = 300
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Sysfailure"
    .Answer = DALICA_OK
  End With

  With CmdArray(16)
    .Base = 301
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Power On"
    .Answer = DALICA_OK
  End With

  With CmdArray(17)
    .Base = 302
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Fade Time"
    .Answer = DALICA_OK
  End With

  With CmdArray(18)
    .Base = 303
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Fade Rate"
    .Answer = DALICA_OK
  End With

  With CmdArray(19)
    .Base = 320
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Scene"
    .Answer = DALICA_OK
  End With

  With CmdArray(20)
    .Base = 336
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_SENDTWICE
    .Descr = "Remove From Scene"
    .Answer = DALICA_OK
  End With

  With CmdArray(21)
    .Base = 352
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_SENDTWICE
    .Descr = "Add To Group"
    .Answer = DALICA_OK
  End With

  With CmdArray(22)
    .Base = 368
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_SENDTWICE
    .Descr = "Remove From Group"
    .Answer = DALICA_OK
  End With

  With CmdArray(23)
    .Base = 384
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Store DTR As Short Address"
    .Answer = DALICA_OK
  End With


  With CmdArray(24)
    .Base = 400
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Status"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(25)
    .Base = 401
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Ballast"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(26)
    .Base = 402
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Lamp Failure"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(27)
    .Base = 403
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Lamp Power On"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(28)
    .Base = 404
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Limit Error"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(29)
    .Base = 405
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Reset State"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(30)
    .Base = 406
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Missing Short Address"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(31)
    .Base = 407
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Version Number"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(32)
    .Base = 408
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Content DTR"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(33)
    .Base = 409
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Device Type"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(34)
    .Base = 410
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Physical Minimum Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(35)
    .Base = 411
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Power Failure"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(36)
    .Base = 416
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Actual Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(37)
    .Base = 417
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Max Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(38)
    .Base = 418
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Min Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(39)
    .Base = 419
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Power On Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(40)
    .Base = 420
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query SysFailure Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(41)
    .Base = 421
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Fade Time/Fade Rate"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(42)
    .Base = 432
    .AMult = 512
    .DMax = 15
    .Flags = DALICD_ANSWER
    .Descr = "Query Scene Level"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(43)
    .Base = 448
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Groups 0-7"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(44)
    .Base = 449
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Groups 8-15"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(45)
    .Base = 450
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Random Address (H)"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(46)
    .Base = 451
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Random Address (M)"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(47)
    .Base = 452
    .AMult = 512
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Random Address (L)"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(48)
    .Base = 480
    .AMult = 512
    .DMax = 31
    .Flags = DALICD_ANSWER
    .Descr = "Query Extend. Commands"
    .Answer = DALICA_8BIT
  End With


  With CmdArray(49)
    .Base = 41216
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Terminate"
    .Answer = DALICA_OK
  End With

  With CmdArray(50)
    .Base = 41728
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Set DTR"
    .Answer = DALICA_OK
  End With

  With CmdArray(51)
    .Base = 42240
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_SENDTWICE
    .Descr = "Initialize"
    .Answer = DALICA_OK
  End With

  With CmdArray(52)
    .Base = 42752
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_SENDTWICE
    .Descr = "Randomize"
    .Answer = DALICA_OK
  End With

  With CmdArray(53)
    .Base = 43264
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Compare"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(54)
    .Base = 43776
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Withdraw"
    .Answer = DALICA_OK
  End With

  With CmdArray(55)
    .Base = 45312
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Set Search Addr (H)"
    .Answer = DALICA_OK
  End With

  With CmdArray(56)
    .Base = 45824
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Set Search Addr (M)"
    .Answer = DALICA_OK
  End With

  With CmdArray(57)
    .Base = 46336
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Set Search Addr (L)"
    .Answer = DALICA_OK
  End With

  With CmdArray(58)
    .Base = 46849
    .AMult = 2
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Program Short Addr"
    .Answer = DALICA_OK
  End With

  With CmdArray(59)
    .Base = 47361
    .AMult = 2
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Verify Short Addr"
    .Answer = DALICA_YESNO
  End With

  With CmdArray(60)
    .Base = 47872
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_ANSWER
    .Descr = "Query Short Addr"
    .Answer = DALICA_8BIT
  End With

  With CmdArray(61)
    .Base = 48384
    .AMult = 0
    .DMax = 0
    .Flags = DALICD_NORMAL
    .Descr = "Physical Selection"
    .Answer = DALICA_OK
  End With

  With CmdArray(62)
    .Base = 49408
    .AMult = 0
    .DMax = 255
    .Flags = DALICD_NORMAL
    .Descr = "Enable Device Type"
    .Answer = DALICA_OK
  End With
  
  
  With CmdArray(63)
    .Base = 464
    .AMult = 512
    .DMax = 7
    .Flags = DALICD_NORMAL
    .Descr = "Store DTR As Fix Point (ST)"
    .Answer = DALICA_OK
  End With
End Sub

Private Sub Class_Initialize()
  LoadDALICommands
  'inCompatMode = False
  hadReset = False
  bInFunction = False
End Sub

Private Sub DALITimer_Timer()
  isAnswerRcvd = True
  isTimedOut = True
End Sub

Private Sub MSCom_OnComm()
  Dim rcvarr As Variant
  Dim ibc%, i%
  
  ibc = MSCom.InBufferCount
  If ibc >= 2 Then
    rcvarr = MSCom.Input
    Answer(0) = rcvarr(0)
    'If Not inCompatMode Then
      If Not (Answer(0) = 0) Then
        Answer(0) = Answer(0) - 1
      Else
        MsgBox "Invalid Frame Received (Errcode==0)" & Chr(13) & "Try using the Compatibility mode."
      End If
    'End If
    Answer(1) = rcvarr(1)
    isAnswerRcvd = True
    If Answer(0) = 6 And Answer(1) = 0 Then
      hadReset = True
    End If
  Else
    rcvarr = MSCom.Input
  End If
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
  
  On Error GoTo ErrorHandler
  'INI_File = PropBag.ReadProperty("INI_File", "DALI.INI")
  noError = False
  'inCompatMode = PropBag.ReadProperty("inCompatMode", False)
  LoadDALICommands
  SendCommandBytes 0, 0, 0  'to avoid short circuit of bus
ErrorHandler:
End Sub

Private Sub UserControl_Resize()
  UserControl.Height = 585
  UserControl.Width = 600
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
  'PropBag.WriteProperty "INI_File", INI_File, "DALI.INI"
  'PropBag.WriteProperty "inCompatMode", inCompatMode, False
End Sub
